// FileRecordDialog.cpp : implementation file
//

#include "stdafx.h"
#include "sc510.h"
#include "sc510Dlg.h"
#include "FileRecordDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFileRecordDialog dialog


CFileRecordDialog::CFileRecordDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CFileRecordDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFileRecordDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CFileRecordDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFileRecordDialog)
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_4_2_, m_edit_record_4_2);
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_4_1_, m_edit_record_4_1);
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_3_2_, m_edit_record_3_2);
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_3_1_, m_edit_record_3_1);
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_2_2_, m_edit_record_2_2);
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_2_1_, m_edit_record_2_1);
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_1_2, m_edit_record_1_2);
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_1_1, m_edit_record_1_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_4_2_, m_btnRecordStop_4_2);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_4_1_, m_btnRecordStop_4_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_3_2_, m_btnRecordStop_3_2);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_3_1_, m_btnRecordStop_3_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_2_2_, m_btnRecordStop_2_2);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_2_1_, m_btnRecordStop_2_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_1_2, m_btnRecordStop_1_2);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_1_1, m_btnRecordStop_1_1);
	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_4_2_, m_checkGPU_4_2);
	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_4_1_, m_checkGPU_4_1);
	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_3_2_, m_checkGPU_3_2);
	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_3_1_, m_checkGPU_3_1);
	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_2_2_, m_checkGPU_2_2);
	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_2_1_, m_checkGPU_2_1);
	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_1_2, m_checkGPU_1_2);
	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_1_1, m_checkGPU_1_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_4_2_, m_btnRecordStart_4_2);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_4_1_, m_btnRecordStart_4_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_3_2_, m_btnRecordStart_3_2);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_3_1_, m_btnRecordStart_3_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_2_2_, m_btnRecordStart_2_2);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_2_1_, m_btnRecordStart_2_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_1_2, m_btnRecordStart_1_2);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_1_1, m_btnRecordStart_1_1);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFileRecordDialog, CDialog)
	//{{AFX_MSG_MAP(CFileRecordDialog)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_1_1, OnButtonRecordStart11)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_1_1, OnButtonRecordStop11)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_1_2, OnButtonRecordStart12)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_1_2, OnButtonRecordStop12)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_2_1_, OnButtonRecordStart21)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_2_1_, OnButtonRecordStop21)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_2_2_, OnButtonRecordStart22)
	ON_BN_CLICKED(IDC_AVI_RADIO_1_1, OnAviRadio11)
	ON_BN_CLICKED(IDC_MP4_RADIO_1_1, OnMp4Radio11)
	ON_BN_CLICKED(IDC_AVI_RADIO_1_2, OnAviRadio12)
	ON_BN_CLICKED(IDC_MP4_RADIO_1_2, OnMp4Radio12)
	ON_BN_CLICKED(IDC_AVI_RADIO_2_1, OnAviRadio21)
	ON_BN_CLICKED(IDC_MP4_RADIO_2_1, OnMp4Radio21)
	ON_BN_CLICKED(IDC_AVI_RADIO_2_2_, OnAviRadio22)
	ON_BN_CLICKED(IDC_MP4_RADIO_2_2_, OnMp4Radio22)
	ON_BN_CLICKED(IDC_AVI_RADIO_3_1_, OnAviRadio31)
	ON_BN_CLICKED(IDC_MP4_RADIO_3_1_, OnMp4Radio31)
	ON_BN_CLICKED(IDC_AVI_RADIO_3_2_, OnAviRadio32)
	ON_BN_CLICKED(IDC_MP4_RADIO_3_2_, OnMp4Radio32)
	ON_BN_CLICKED(IDC_AVI_RADIO_4_1, OnAviRadio41)
	ON_BN_CLICKED(IDC_MP4_RADIO_4_1, OnMp4Radio41)
	ON_BN_CLICKED(IDC_AVI_RADIO_4_2, OnAviRadio42)
	ON_BN_CLICKED(IDC_MP4_RADIO_4_2, OnMp4Radio422)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_2_2_, OnButtonRecordStop22)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_3_1_, OnButtonRecordStart31)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_3_2_, OnButtonRecordStart32)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_3_1_, OnButtonRecordStop31)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_3_2_, OnButtonRecordStop32)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_4_1_, OnButtonRecordStart41)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_4_1_, OnButtonRecordStop41)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_4_2_, OnButtonRecordStart42)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_4_2_, OnButtonRecordStop42)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFileRecordDialog message handlers

void CFileRecordDialog::OnButtonRecordStart11() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_btnRecordStart_1_1.EnableWindow( FALSE ); 

	m_btnRecordStop_1_1.EnableWindow( TRUE ); 

	m_pMainDialog->m_bSupportGPU1_1 = m_checkGPU_1_1.GetCheck();

	if ( m_pMainDialog->m_hVideoDevice[ 0 ] != 0 ) {

		CString strFullPathName;

		UINT iCheckedAVI, iCheckedMP4;

		iCheckedAVI = IsDlgButtonChecked( IDC_AVI_RADIO_1_1 );

		iCheckedMP4 = IsDlgButtonChecked( IDC_MP4_RADIO_1_1 );

		if ( iCheckedAVI == BST_CHECKED ) {
			
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 0 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname1_1_1080_12M.avi");
		}

        if ( iCheckedMP4 == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 0 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname1_1_1080_12M.mp4");
		}

		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

		if ( m_pMainDialog->m_bSupportGPU1_1 ) {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 0 ], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

			QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 0 ], 0, psz );
		}
		else {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 0 ], 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

			QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 0 ], 0, psz );
		}

		m_pMainDialog->m_bIsRecord1_1 = true;

		strFullPathName.ReleaseBuffer();
	}
}

void CFileRecordDialog::OnButtonRecordStop11() 
{
	// TODO: Add your control notification handler code here

 	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_btnRecordStart_1_1.EnableWindow( TRUE ); 

	m_btnRecordStop_1_1.EnableWindow( FALSE ); 

	if ( m_pMainDialog->m_hVideoDevice[ 0 ] != 0 ) {

		QCAP_STOP_RECORD( m_pMainDialog->m_hVideoDevice[ 0 ], 0, TRUE, 0 );

		m_pMainDialog->m_bIsRecord1_1 = false;
	}
}

void CFileRecordDialog::OnButtonRecordStart12() 
{
	// TODO: Add your control notification handler code here

 	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_btnRecordStart_1_2.EnableWindow( FALSE ); 

	m_btnRecordStop_1_2.EnableWindow( TRUE ); 

	m_pMainDialog->m_bSupportGPU1_2 = m_checkGPU_1_2.GetCheck();

	if ( m_pMainDialog->m_hVideoDevice[ 0 ] != 0 ) {
		
		CString strFullPathName;

		UINT iCheckedAVI, iCheckedMP4;

		iCheckedAVI = IsDlgButtonChecked( IDC_AVI_RADIO_1_2 );

		iCheckedMP4 = IsDlgButtonChecked( IDC_MP4_RADIO_1_2 );

		if ( iCheckedAVI == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 0 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname1_2_480_6M.avi");
		}

        if ( iCheckedMP4 == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 0 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname1_2_480_6M.mp4");
		}

		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

		if ( m_pMainDialog->m_bSupportGPU1_2 ) {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 0 ], 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );

			QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 0 ], 1, psz );			
		}
		else {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 0 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );

			QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 0 ], 1, psz );
		}

		m_pMainDialog->m_bIsRecord1_2 = true;

		strFullPathName.ReleaseBuffer();
	}
}

void CFileRecordDialog::OnButtonRecordStop12() 
{
	// TODO: Add your control notification handler code here

 	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_btnRecordStart_1_2.EnableWindow( TRUE );

	m_btnRecordStop_1_2.EnableWindow( FALSE ); 

	if ( m_pMainDialog->m_hVideoDevice[ 0 ] != 0 ) {

		QCAP_STOP_RECORD( m_pMainDialog->m_hVideoDevice[ 0 ], 1 );

		m_pMainDialog->m_bIsRecord1_2 = false;
	}	
}

void CFileRecordDialog::OnButtonRecordStart21() 
{
	// TODO: Add your control notification handler code here

 	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_btnRecordStart_2_1.EnableWindow( FALSE ); 

	m_btnRecordStop_2_1.EnableWindow( TRUE ); 

	m_pMainDialog->m_bSupportGPU2_1 = m_checkGPU_2_1.GetCheck();

	if ( m_pMainDialog->m_hVideoDevice[ 1 ] != 0 ) {

		CString strFullPathName;

		UINT iCheckedAVI, iCheckedMP4;

		iCheckedAVI = IsDlgButtonChecked( IDC_AVI_RADIO_2_1 );

		iCheckedMP4 = IsDlgButtonChecked( IDC_MP4_RADIO_2_1 );

		if ( iCheckedAVI == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 1 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname2_1_1080_12M.avi");
		}

        if ( iCheckedMP4 == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 1 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname2_1_1080_12M.mp4");
		}

		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

		if ( m_pMainDialog->m_bSupportGPU2_1 ) {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 1 ], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

			QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 1 ], 0, psz );			
		}
		else {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 1 ], 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

			QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 1 ], 0, psz );
		}

		m_pMainDialog->m_bIsRecord2_1 = true;

		strFullPathName.ReleaseBuffer();
	}	
}

void CFileRecordDialog::OnButtonRecordStop21() 
{
	// TODO: Add your control notification handler code here

 	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	//m_pMainDialog->OnButtonRecordStop2_1_SetupDialog();

	m_btnRecordStart_2_1.EnableWindow( TRUE ); 

	m_btnRecordStop_2_1.EnableWindow( FALSE ); 

	if ( m_pMainDialog->m_hVideoDevice[ 1 ] != 0 ) {

		QCAP_STOP_RECORD( m_pMainDialog->m_hVideoDevice[ 1 ], 0 );

		m_pMainDialog->m_bIsRecord2_1 = false;
	}	
}

void CFileRecordDialog::OnButtonRecordStart22() 
{
	// TODO: Add your control notification handler code here

 	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_btnRecordStart_2_2.EnableWindow( FALSE ); 

	m_btnRecordStop_2_2.EnableWindow( TRUE ); 

	m_pMainDialog->m_bSupportGPU2_2 = m_checkGPU_2_2.GetCheck();

	if ( m_pMainDialog->m_hVideoDevice[ 1 ] != 0 ) 
	{
		CString strFullPathName;

		UINT iCheckedAVI, iCheckedMP4;

		iCheckedAVI = IsDlgButtonChecked( IDC_AVI_RADIO_2_2_ );

		iCheckedMP4 = IsDlgButtonChecked( IDC_MP4_RADIO_2_2_ );

		if ( iCheckedAVI == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 1 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname2_2_480_6M.avi");
		}

        if ( iCheckedMP4 == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 1 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname2_2_480_6M.mp4");
		}

		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

		if ( m_pMainDialog->m_bSupportGPU2_2 ) {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 1 ], 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );

			QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 1 ], 1, psz );			
		}
		else {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 1 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );

			QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 1 ], 1, psz );
		}

		m_pMainDialog->m_bIsRecord2_2 = true;

		strFullPathName.ReleaseBuffer();
	}

}

BOOL CFileRecordDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	// SET PAHT
	::GetModuleFileName( 0, m_pMainDialog->m_strSnapshotPath.GetBufferSetLength( MAX_PATH + 1 ), MAX_PATH );
	
	m_pMainDialog->m_strSnapshotPath.ReleaseBuffer();

	INT nPos;

	nPos = m_pMainDialog->m_strSnapshotPath.ReverseFind('\\');
	
	// GET PATH
	m_pMainDialog->m_strSnapshotPath = m_pMainDialog->m_strSnapshotPath.Left( nPos );
	
	m_pMainDialog->m_strRecordPath = m_pMainDialog->m_strSnapshotPath;

	CString strFullPath;
	
	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname1_1_1080_12M.mp4"));

	m_edit_record_1_1.SetWindowText( (LPCTSTR)strFullPath );

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname1_2_480_6M.mp4"));

	m_edit_record_1_2.SetWindowText( (LPCTSTR)strFullPath );

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname2_1_1080_12M.mp4"));

	m_edit_record_2_1.SetWindowText( (LPCTSTR)strFullPath );

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname2_2_480_6M.mp4"));

	m_edit_record_2_2.SetWindowText( (LPCTSTR)strFullPath );

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname3_1_1080_12M.mp4"));

	m_edit_record_3_1.SetWindowText( (LPCTSTR)strFullPath );

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname3_2_480_6M.mp4"));

	m_edit_record_3_2.SetWindowText( (LPCTSTR)strFullPath );

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname4_1_1080_12M.mp4"));

	m_edit_record_4_1.SetWindowText( (LPCTSTR)strFullPath );

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname4_2_480_6M.mp4"));

	m_edit_record_4_2.SetWindowText( (LPCTSTR)strFullPath );

	CheckDlgButton( IDC_AVI_RADIO_1_1, BST_UNCHECKED );

	CheckDlgButton( IDC_AVI_RADIO_1_2, BST_UNCHECKED );

	CheckDlgButton( IDC_AVI_RADIO_2_1, BST_UNCHECKED );

	CheckDlgButton( IDC_AVI_RADIO_2_2_, BST_UNCHECKED );

	CheckDlgButton( IDC_AVI_RADIO_3_1_, BST_UNCHECKED );

	CheckDlgButton( IDC_AVI_RADIO_3_2_, BST_UNCHECKED );

	CheckDlgButton( IDC_AVI_RADIO_4_1, BST_UNCHECKED );

	CheckDlgButton( IDC_AVI_RADIO_4_2, BST_UNCHECKED );

	CheckDlgButton( IDC_MP4_RADIO_1_1, BST_CHECKED );

	CheckDlgButton( IDC_MP4_RADIO_1_2, BST_CHECKED );

	CheckDlgButton( IDC_MP4_RADIO_2_1, BST_CHECKED );

	CheckDlgButton( IDC_MP4_RADIO_2_2_, BST_CHECKED );

	CheckDlgButton( IDC_MP4_RADIO_3_1_, BST_CHECKED );

	CheckDlgButton( IDC_MP4_RADIO_3_2_, BST_CHECKED );

	CheckDlgButton( IDC_MP4_RADIO_4_1, BST_CHECKED );

	CheckDlgButton( IDC_MP4_RADIO_4_2, BST_CHECKED );

	for ( ULONG i = 0; i < 4; i++ ) {
		
		if ( i == 0 ) {
			
			if ( m_pMainDialog->m_hVideoDevice[ i ] != 0 ) {

				m_btnRecordStart_1_1.EnableWindow( TRUE ); 

				m_btnRecordStop_1_1.EnableWindow( FALSE ); 

				m_btnRecordStart_1_2.EnableWindow( TRUE ); 

				m_btnRecordStop_1_2.EnableWindow( FALSE ); 
				
				m_checkGPU_1_1.EnableWindow( FALSE ); 

				m_checkGPU_1_1.SetCheck( 0 );

				m_checkGPU_1_2.EnableWindow( TRUE ); 

				m_checkGPU_1_2.SetCheck( 0 );
				
				GetDlgItem( IDC_AVI_RADIO_1_1 )->EnableWindow( TRUE );

				GetDlgItem( IDC_MP4_RADIO_1_1 )->EnableWindow( TRUE );

				GetDlgItem( IDC_AVI_RADIO_1_2 )->EnableWindow( TRUE );

				GetDlgItem( IDC_MP4_RADIO_1_2 )->EnableWindow( TRUE );
			}
			else {
			
				m_btnRecordStart_1_1.EnableWindow( FALSE ); 

				m_btnRecordStop_1_1.EnableWindow( FALSE ); 

				m_btnRecordStart_1_2.EnableWindow( FALSE ); 

				m_btnRecordStop_1_2.EnableWindow( FALSE ); 
				
				m_checkGPU_1_1.EnableWindow( FALSE ); 

				m_checkGPU_1_1.SetCheck( 0 );

				m_checkGPU_1_2.EnableWindow( FALSE ); 

				m_checkGPU_1_2.SetCheck( 0 );

				GetDlgItem( IDC_AVI_RADIO_1_1 )->EnableWindow( FALSE );

				GetDlgItem( IDC_MP4_RADIO_1_1 )->EnableWindow( FALSE );

				GetDlgItem( IDC_AVI_RADIO_1_2 )->EnableWindow( FALSE );

				GetDlgItem( IDC_MP4_RADIO_1_2 )->EnableWindow( FALSE );
			}
		}

		if ( i == 1 ) {
			
			if ( m_pMainDialog->m_hVideoDevice[ i ] != 0 ) {

				m_btnRecordStart_2_1.EnableWindow( TRUE ); 

				m_btnRecordStop_2_1.EnableWindow( FALSE ); 

				m_btnRecordStart_2_2.EnableWindow( TRUE ); 

				m_btnRecordStop_2_2.EnableWindow( FALSE ); 
				
				m_checkGPU_2_1.EnableWindow( FALSE ); 

				m_checkGPU_2_1.SetCheck( 0 );

				m_checkGPU_2_2.EnableWindow( TRUE ); 

				m_checkGPU_2_2.SetCheck( 0 );
				
				GetDlgItem( IDC_AVI_RADIO_2_1 )->EnableWindow( TRUE );

				GetDlgItem( IDC_MP4_RADIO_2_1 )->EnableWindow( TRUE );

				GetDlgItem( IDC_AVI_RADIO_2_2_ )->EnableWindow( TRUE );

				GetDlgItem( IDC_MP4_RADIO_2_2_ )->EnableWindow( TRUE );
			}
			else {
			
				m_btnRecordStart_2_1.EnableWindow( FALSE ); 

				m_btnRecordStop_2_1.EnableWindow( FALSE ); 

				m_btnRecordStart_2_2.EnableWindow( FALSE ); 

				m_btnRecordStop_2_2.EnableWindow( FALSE ); 
				
				m_checkGPU_2_1.EnableWindow( FALSE ); 

				m_checkGPU_2_1.SetCheck( 0 );

				m_checkGPU_2_2.EnableWindow( FALSE ); 

				m_checkGPU_2_2.SetCheck( 0 );

				GetDlgItem( IDC_AVI_RADIO_2_1 )->EnableWindow( FALSE );

				GetDlgItem( IDC_MP4_RADIO_2_1 )->EnableWindow( FALSE );

				GetDlgItem( IDC_AVI_RADIO_2_2_ )->EnableWindow( FALSE );

				GetDlgItem( IDC_MP4_RADIO_2_2_ )->EnableWindow( FALSE );			
			}
		}

		if ( i == 2 ) {
			
			if ( m_pMainDialog->m_hVideoDevice[ i ] != 0 ) {

				m_btnRecordStart_3_1.EnableWindow( TRUE ); 

				m_btnRecordStop_3_1.EnableWindow( FALSE ); 

				m_btnRecordStart_3_2.EnableWindow( TRUE ); 

				m_btnRecordStop_3_2.EnableWindow( FALSE ); 
				
				m_checkGPU_3_1.EnableWindow( FALSE ); 

				m_checkGPU_3_1.SetCheck( 0 );

				m_checkGPU_3_2.EnableWindow( TRUE ); 

				m_checkGPU_3_2.SetCheck( 0 );
				
				GetDlgItem( IDC_AVI_RADIO_3_1_ )->EnableWindow( TRUE );

				GetDlgItem( IDC_MP4_RADIO_3_1_ )->EnableWindow( TRUE );

				GetDlgItem( IDC_AVI_RADIO_3_2_ )->EnableWindow( TRUE );

				GetDlgItem( IDC_MP4_RADIO_3_2_ )->EnableWindow( TRUE );
			}
			else {
			
				m_btnRecordStart_3_1.EnableWindow( FALSE ); 

				m_btnRecordStop_3_1.EnableWindow( FALSE ); 

				m_btnRecordStart_3_2.EnableWindow( FALSE ); 

				m_btnRecordStop_3_2.EnableWindow( FALSE ); 
				
				m_checkGPU_3_1.EnableWindow( FALSE ); 

				m_checkGPU_3_1.SetCheck( 0 );

				m_checkGPU_3_2.EnableWindow( FALSE ); 

				m_checkGPU_3_2.SetCheck( 0 );
				
				GetDlgItem( IDC_AVI_RADIO_3_1_ )->EnableWindow( FALSE );

				GetDlgItem( IDC_MP4_RADIO_3_1_ )->EnableWindow( FALSE );

				GetDlgItem( IDC_AVI_RADIO_3_2_ )->EnableWindow( FALSE );

				GetDlgItem( IDC_MP4_RADIO_3_2_ )->EnableWindow( FALSE );
			}
		}

		if ( i == 3 ) {
			
			if ( m_pMainDialog->m_hVideoDevice[ i ] != 0 ) {

				m_btnRecordStart_4_1.EnableWindow( TRUE ); 

				m_btnRecordStop_4_1.EnableWindow( FALSE ); 

				m_btnRecordStart_4_2.EnableWindow( TRUE ); 

				m_btnRecordStop_4_2.EnableWindow( FALSE ); 
				
				m_checkGPU_4_1.EnableWindow( FALSE ); 

				m_checkGPU_4_1.SetCheck( 0 );

				m_checkGPU_4_2.EnableWindow( TRUE ); 

				m_checkGPU_4_2.SetCheck( 0 );
				
				GetDlgItem( IDC_AVI_RADIO_4_1 )->EnableWindow( TRUE );

				GetDlgItem( IDC_MP4_RADIO_4_1 )->EnableWindow( TRUE );

				GetDlgItem( IDC_AVI_RADIO_4_2 )->EnableWindow( TRUE );

				GetDlgItem( IDC_MP4_RADIO_4_2 )->EnableWindow( TRUE );
			}
			else {
			
				m_btnRecordStart_4_1.EnableWindow( FALSE ); 

				m_btnRecordStop_4_1.EnableWindow( FALSE ); 

				m_btnRecordStart_4_2.EnableWindow( FALSE ); 

				m_btnRecordStop_4_2.EnableWindow( FALSE ); 
				
				m_checkGPU_4_1.EnableWindow( FALSE ); 

				m_checkGPU_4_1.SetCheck( 0 );

				m_checkGPU_4_2.EnableWindow( FALSE ); 

				m_checkGPU_4_2.SetCheck( 0 );
				
				GetDlgItem( IDC_AVI_RADIO_4_1 )->EnableWindow( FALSE );

				GetDlgItem( IDC_MP4_RADIO_4_1 )->EnableWindow( FALSE );

				GetDlgItem( IDC_AVI_RADIO_4_2 )->EnableWindow( FALSE );

				GetDlgItem( IDC_MP4_RADIO_4_2 )->EnableWindow( FALSE );
			}			
		}
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFileRecordDialog::OnAviRadio11() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname1_1_1080_12M.avi"));

	m_edit_record_1_1.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1, iCheckedAVI_1_2, iCheckedMP4_1_2;
	
	UINT iCheckedAVI_2_1, iCheckedMP4_2_1, iCheckedAVI_2_2, iCheckedMP4_2_2;

	UINT iCheckedAVI_3_1, iCheckedMP4_3_1, iCheckedAVI_3_2, iCheckedMP4_3_2;
	
	UINT iCheckedAVI_4_1, iCheckedMP4_4_1, iCheckedAVI_4_2, iCheckedMP4_4_2;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->GetCheck();

	iCheckedAVI_1_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->GetCheck();

	iCheckedMP4_1_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->GetCheck();

	iCheckedAVI_2_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->GetCheck();

	iCheckedMP4_2_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->GetCheck();
	
	iCheckedAVI_2_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_2_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->GetCheck();

	iCheckedAVI_3_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->GetCheck();		

	iCheckedMP4_3_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->GetCheck();

	iCheckedAVI_3_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->GetCheck();
	
	iCheckedMP4_3_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->GetCheck();

	iCheckedAVI_4_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->GetCheck();		

	iCheckedMP4_4_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->GetCheck();

	iCheckedAVI_4_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->GetCheck();
	
	iCheckedMP4_4_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_1_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedAVI_2_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->SetCheck( TRUE ); }	

	if ( iCheckedAVI_2_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnMp4Radio11() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname1_1_1080_12M.mp4"));

	m_edit_record_1_1.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1, iCheckedAVI_1_2, iCheckedMP4_1_2;
	
	UINT iCheckedAVI_2_1, iCheckedMP4_2_1, iCheckedAVI_2_2, iCheckedMP4_2_2;

	UINT iCheckedAVI_3_1, iCheckedMP4_3_1, iCheckedAVI_3_2, iCheckedMP4_3_2;
	
	UINT iCheckedAVI_4_1, iCheckedMP4_4_1, iCheckedAVI_4_2, iCheckedMP4_4_2;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->GetCheck();

	iCheckedAVI_1_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->GetCheck();

	iCheckedMP4_1_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->GetCheck();

	iCheckedAVI_2_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->GetCheck();

	iCheckedMP4_2_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->GetCheck();
	
	iCheckedAVI_2_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_2_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->GetCheck();

	iCheckedAVI_3_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->GetCheck();		

	iCheckedMP4_3_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->GetCheck();

	iCheckedAVI_3_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->GetCheck();
	
	iCheckedMP4_3_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->GetCheck();

	iCheckedAVI_4_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->GetCheck();		

	iCheckedMP4_4_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->GetCheck();

	iCheckedAVI_4_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->GetCheck();
	
	iCheckedMP4_4_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_1_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedAVI_2_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->SetCheck( TRUE ); }	

	if ( iCheckedAVI_2_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnAviRadio12() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname1_2_480_6M.avi"));

	m_edit_record_1_2.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1, iCheckedAVI_1_2, iCheckedMP4_1_2;
	
	UINT iCheckedAVI_2_1, iCheckedMP4_2_1, iCheckedAVI_2_2, iCheckedMP4_2_2;

	UINT iCheckedAVI_3_1, iCheckedMP4_3_1, iCheckedAVI_3_2, iCheckedMP4_3_2;
	
	UINT iCheckedAVI_4_1, iCheckedMP4_4_1, iCheckedAVI_4_2, iCheckedMP4_4_2;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->GetCheck();

	iCheckedAVI_1_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->GetCheck();

	iCheckedMP4_1_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->GetCheck();

	iCheckedAVI_2_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->GetCheck();

	iCheckedMP4_2_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->GetCheck();
	
	iCheckedAVI_2_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_2_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->GetCheck();

	iCheckedAVI_3_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->GetCheck();		

	iCheckedMP4_3_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->GetCheck();

	iCheckedAVI_3_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->GetCheck();
	
	iCheckedMP4_3_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->GetCheck();

	iCheckedAVI_4_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->GetCheck();		

	iCheckedMP4_4_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->GetCheck();

	iCheckedAVI_4_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->GetCheck();
	
	iCheckedMP4_4_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_1_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedAVI_2_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->SetCheck( TRUE ); }	

	if ( iCheckedAVI_2_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnMp4Radio12() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname1_2_480_6M.mp4"));

	m_edit_record_1_2.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1, iCheckedAVI_1_2, iCheckedMP4_1_2;
	
	UINT iCheckedAVI_2_1, iCheckedMP4_2_1, iCheckedAVI_2_2, iCheckedMP4_2_2;

	UINT iCheckedAVI_3_1, iCheckedMP4_3_1, iCheckedAVI_3_2, iCheckedMP4_3_2;
	
	UINT iCheckedAVI_4_1, iCheckedMP4_4_1, iCheckedAVI_4_2, iCheckedMP4_4_2;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->GetCheck();

	iCheckedAVI_1_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->GetCheck();

	iCheckedMP4_1_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->GetCheck();

	iCheckedAVI_2_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->GetCheck();

	iCheckedMP4_2_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->GetCheck();
	
	iCheckedAVI_2_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_2_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->GetCheck();

	iCheckedAVI_3_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->GetCheck();		

	iCheckedMP4_3_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->GetCheck();

	iCheckedAVI_3_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->GetCheck();
	
	iCheckedMP4_3_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->GetCheck();

	iCheckedAVI_4_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->GetCheck();		

	iCheckedMP4_4_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->GetCheck();

	iCheckedAVI_4_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->GetCheck();
	
	iCheckedMP4_4_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_1_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedAVI_2_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->SetCheck( TRUE ); }	

	if ( iCheckedAVI_2_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->SetCheck( TRUE ); }		
}

void CFileRecordDialog::OnAviRadio21() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname2_1_1080_12M.avi"));

	m_edit_record_2_1.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1, iCheckedAVI_1_2, iCheckedMP4_1_2;
	
	UINT iCheckedAVI_2_1, iCheckedMP4_2_1, iCheckedAVI_2_2, iCheckedMP4_2_2;

	UINT iCheckedAVI_3_1, iCheckedMP4_3_1, iCheckedAVI_3_2, iCheckedMP4_3_2;
	
	UINT iCheckedAVI_4_1, iCheckedMP4_4_1, iCheckedAVI_4_2, iCheckedMP4_4_2;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->GetCheck();

	iCheckedAVI_1_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->GetCheck();

	iCheckedMP4_1_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->GetCheck();

	iCheckedAVI_2_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->GetCheck();

	iCheckedMP4_2_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->GetCheck();
	
	iCheckedAVI_2_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_2_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->GetCheck();

	iCheckedAVI_3_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->GetCheck();		

	iCheckedMP4_3_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->GetCheck();

	iCheckedAVI_3_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->GetCheck();
	
	iCheckedMP4_3_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->GetCheck();

	iCheckedAVI_4_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->GetCheck();		

	iCheckedMP4_4_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->GetCheck();

	iCheckedAVI_4_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->GetCheck();
	
	iCheckedMP4_4_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_1_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedAVI_2_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->SetCheck( TRUE ); }	

	if ( iCheckedAVI_2_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnMp4Radio21() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname2_1_1080_12M.mp4"));

	m_edit_record_2_1.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1, iCheckedAVI_1_2, iCheckedMP4_1_2;
	
	UINT iCheckedAVI_2_1, iCheckedMP4_2_1, iCheckedAVI_2_2, iCheckedMP4_2_2;

	UINT iCheckedAVI_3_1, iCheckedMP4_3_1, iCheckedAVI_3_2, iCheckedMP4_3_2;
	
	UINT iCheckedAVI_4_1, iCheckedMP4_4_1, iCheckedAVI_4_2, iCheckedMP4_4_2;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->GetCheck();

	iCheckedAVI_1_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->GetCheck();

	iCheckedMP4_1_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->GetCheck();

	iCheckedAVI_2_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->GetCheck();

	iCheckedMP4_2_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->GetCheck();
	
	iCheckedAVI_2_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_2_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->GetCheck();

	iCheckedAVI_3_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->GetCheck();		

	iCheckedMP4_3_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->GetCheck();

	iCheckedAVI_3_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->GetCheck();
	
	iCheckedMP4_3_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->GetCheck();

	iCheckedAVI_4_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->GetCheck();		

	iCheckedMP4_4_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->GetCheck();

	iCheckedAVI_4_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->GetCheck();
	
	iCheckedMP4_4_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_1_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedAVI_2_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->SetCheck( TRUE ); }	

	if ( iCheckedAVI_2_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnAviRadio22() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname2_2_480_6M.avi"));

	m_edit_record_2_2.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1, iCheckedAVI_1_2, iCheckedMP4_1_2;
	
	UINT iCheckedAVI_2_1, iCheckedMP4_2_1, iCheckedAVI_2_2, iCheckedMP4_2_2;

	UINT iCheckedAVI_3_1, iCheckedMP4_3_1, iCheckedAVI_3_2, iCheckedMP4_3_2;
	
	UINT iCheckedAVI_4_1, iCheckedMP4_4_1, iCheckedAVI_4_2, iCheckedMP4_4_2;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->GetCheck();

	iCheckedAVI_1_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->GetCheck();

	iCheckedMP4_1_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->GetCheck();

	iCheckedAVI_2_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->GetCheck();

	iCheckedMP4_2_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->GetCheck();
	
	iCheckedAVI_2_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_2_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->GetCheck();

	iCheckedAVI_3_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->GetCheck();		

	iCheckedMP4_3_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->GetCheck();

	iCheckedAVI_3_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->GetCheck();
	
	iCheckedMP4_3_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->GetCheck();

	iCheckedAVI_4_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->GetCheck();		

	iCheckedMP4_4_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->GetCheck();

	iCheckedAVI_4_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->GetCheck();
	
	iCheckedMP4_4_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_1_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedAVI_2_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->SetCheck( TRUE ); }	

	if ( iCheckedAVI_2_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnMp4Radio22() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname2_2_480_6M.mp4"));

	m_edit_record_2_2.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1, iCheckedAVI_1_2, iCheckedMP4_1_2;
	
	UINT iCheckedAVI_2_1, iCheckedMP4_2_1, iCheckedAVI_2_2, iCheckedMP4_2_2;

	UINT iCheckedAVI_3_1, iCheckedMP4_3_1, iCheckedAVI_3_2, iCheckedMP4_3_2;
	
	UINT iCheckedAVI_4_1, iCheckedMP4_4_1, iCheckedAVI_4_2, iCheckedMP4_4_2;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->GetCheck();

	iCheckedAVI_1_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->GetCheck();

	iCheckedMP4_1_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->GetCheck();

	iCheckedAVI_2_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->GetCheck();

	iCheckedMP4_2_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->GetCheck();
	
	iCheckedAVI_2_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_2_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->GetCheck();

	iCheckedAVI_3_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->GetCheck();		

	iCheckedMP4_3_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->GetCheck();

	iCheckedAVI_3_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->GetCheck();
	
	iCheckedMP4_3_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->GetCheck();

	iCheckedAVI_4_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->GetCheck();		

	iCheckedMP4_4_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->GetCheck();

	iCheckedAVI_4_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->GetCheck();
	
	iCheckedMP4_4_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_1_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedAVI_2_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->SetCheck( TRUE ); }	

	if ( iCheckedAVI_2_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnAviRadio31() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname3_1_1080_12M.avi"));

	m_edit_record_3_1.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1, iCheckedAVI_1_2, iCheckedMP4_1_2;
	
	UINT iCheckedAVI_2_1, iCheckedMP4_2_1, iCheckedAVI_2_2, iCheckedMP4_2_2;

	UINT iCheckedAVI_3_1, iCheckedMP4_3_1, iCheckedAVI_3_2, iCheckedMP4_3_2;
	
	UINT iCheckedAVI_4_1, iCheckedMP4_4_1, iCheckedAVI_4_2, iCheckedMP4_4_2;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->GetCheck();

	iCheckedAVI_1_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->GetCheck();

	iCheckedMP4_1_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->GetCheck();

	iCheckedAVI_2_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->GetCheck();

	iCheckedMP4_2_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->GetCheck();
	
	iCheckedAVI_2_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_2_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->GetCheck();

	iCheckedAVI_3_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->GetCheck();		

	iCheckedMP4_3_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->GetCheck();

	iCheckedAVI_3_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->GetCheck();
	
	iCheckedMP4_3_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->GetCheck();

	iCheckedAVI_4_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->GetCheck();		

	iCheckedMP4_4_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->GetCheck();

	iCheckedAVI_4_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->GetCheck();
	
	iCheckedMP4_4_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_1_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedAVI_2_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->SetCheck( TRUE ); }	

	if ( iCheckedAVI_2_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->SetCheck( TRUE ); }		
}

void CFileRecordDialog::OnMp4Radio31() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname3_1_1080_12M.mp4"));

	m_edit_record_3_1.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1, iCheckedAVI_1_2, iCheckedMP4_1_2;
	
	UINT iCheckedAVI_2_1, iCheckedMP4_2_1, iCheckedAVI_2_2, iCheckedMP4_2_2;

	UINT iCheckedAVI_3_1, iCheckedMP4_3_1, iCheckedAVI_3_2, iCheckedMP4_3_2;
	
	UINT iCheckedAVI_4_1, iCheckedMP4_4_1, iCheckedAVI_4_2, iCheckedMP4_4_2;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->GetCheck();

	iCheckedAVI_1_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->GetCheck();

	iCheckedMP4_1_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->GetCheck();

	iCheckedAVI_2_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->GetCheck();

	iCheckedMP4_2_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->GetCheck();
	
	iCheckedAVI_2_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_2_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->GetCheck();

	iCheckedAVI_3_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->GetCheck();		

	iCheckedMP4_3_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->GetCheck();

	iCheckedAVI_3_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->GetCheck();
	
	iCheckedMP4_3_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->GetCheck();

	iCheckedAVI_4_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->GetCheck();		

	iCheckedMP4_4_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->GetCheck();

	iCheckedAVI_4_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->GetCheck();
	
	iCheckedMP4_4_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_1_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedAVI_2_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->SetCheck( TRUE ); }	

	if ( iCheckedAVI_2_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnAviRadio32() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname3_2_480_6M.avi"));

	m_edit_record_3_2.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1, iCheckedAVI_1_2, iCheckedMP4_1_2;
	
	UINT iCheckedAVI_2_1, iCheckedMP4_2_1, iCheckedAVI_2_2, iCheckedMP4_2_2;

	UINT iCheckedAVI_3_1, iCheckedMP4_3_1, iCheckedAVI_3_2, iCheckedMP4_3_2;
	
	UINT iCheckedAVI_4_1, iCheckedMP4_4_1, iCheckedAVI_4_2, iCheckedMP4_4_2;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->GetCheck();

	iCheckedAVI_1_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->GetCheck();

	iCheckedMP4_1_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->GetCheck();

	iCheckedAVI_2_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->GetCheck();

	iCheckedMP4_2_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->GetCheck();
	
	iCheckedAVI_2_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_2_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->GetCheck();

	iCheckedAVI_3_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->GetCheck();		

	iCheckedMP4_3_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->GetCheck();

	iCheckedAVI_3_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->GetCheck();
	
	iCheckedMP4_3_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->GetCheck();

	iCheckedAVI_4_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->GetCheck();		

	iCheckedMP4_4_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->GetCheck();

	iCheckedAVI_4_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->GetCheck();
	
	iCheckedMP4_4_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_1_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedAVI_2_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->SetCheck( TRUE ); }	

	if ( iCheckedAVI_2_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnMp4Radio32() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname3_2_480_6M.mp4"));

	m_edit_record_3_2.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1, iCheckedAVI_1_2, iCheckedMP4_1_2;
	
	UINT iCheckedAVI_2_1, iCheckedMP4_2_1, iCheckedAVI_2_2, iCheckedMP4_2_2;

	UINT iCheckedAVI_3_1, iCheckedMP4_3_1, iCheckedAVI_3_2, iCheckedMP4_3_2;
	
	UINT iCheckedAVI_4_1, iCheckedMP4_4_1, iCheckedAVI_4_2, iCheckedMP4_4_2;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->GetCheck();

	iCheckedAVI_1_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->GetCheck();

	iCheckedMP4_1_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->GetCheck();

	iCheckedAVI_2_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->GetCheck();

	iCheckedMP4_2_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->GetCheck();
	
	iCheckedAVI_2_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_2_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->GetCheck();

	iCheckedAVI_3_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->GetCheck();		

	iCheckedMP4_3_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->GetCheck();

	iCheckedAVI_3_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->GetCheck();
	
	iCheckedMP4_3_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->GetCheck();

	iCheckedAVI_4_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->GetCheck();		

	iCheckedMP4_4_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->GetCheck();

	iCheckedAVI_4_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->GetCheck();
	
	iCheckedMP4_4_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_1_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedAVI_2_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->SetCheck( TRUE ); }	

	if ( iCheckedAVI_2_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnAviRadio41() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname4_1_1080_12M.avi"));

	m_edit_record_4_1.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1, iCheckedAVI_1_2, iCheckedMP4_1_2;
	
	UINT iCheckedAVI_2_1, iCheckedMP4_2_1, iCheckedAVI_2_2, iCheckedMP4_2_2;

	UINT iCheckedAVI_3_1, iCheckedMP4_3_1, iCheckedAVI_3_2, iCheckedMP4_3_2;
	
	UINT iCheckedAVI_4_1, iCheckedMP4_4_1, iCheckedAVI_4_2, iCheckedMP4_4_2;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->GetCheck();

	iCheckedAVI_1_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->GetCheck();

	iCheckedMP4_1_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->GetCheck();

	iCheckedAVI_2_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->GetCheck();

	iCheckedMP4_2_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->GetCheck();
	
	iCheckedAVI_2_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_2_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->GetCheck();

	iCheckedAVI_3_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->GetCheck();		

	iCheckedMP4_3_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->GetCheck();

	iCheckedAVI_3_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->GetCheck();
	
	iCheckedMP4_3_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->GetCheck();

	iCheckedAVI_4_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->GetCheck();		

	iCheckedMP4_4_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->GetCheck();

	iCheckedAVI_4_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->GetCheck();
	
	iCheckedMP4_4_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_1_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedAVI_2_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->SetCheck( TRUE ); }	

	if ( iCheckedAVI_2_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnMp4Radio41() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname4_1_1080_12M.mp4"));

	m_edit_record_4_1.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1, iCheckedAVI_1_2, iCheckedMP4_1_2;
	
	UINT iCheckedAVI_2_1, iCheckedMP4_2_1, iCheckedAVI_2_2, iCheckedMP4_2_2;

	UINT iCheckedAVI_3_1, iCheckedMP4_3_1, iCheckedAVI_3_2, iCheckedMP4_3_2;
	
	UINT iCheckedAVI_4_1, iCheckedMP4_4_1, iCheckedAVI_4_2, iCheckedMP4_4_2;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->GetCheck();

	iCheckedAVI_1_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->GetCheck();

	iCheckedMP4_1_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->GetCheck();

	iCheckedAVI_2_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->GetCheck();

	iCheckedMP4_2_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->GetCheck();
	
	iCheckedAVI_2_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_2_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->GetCheck();

	iCheckedAVI_3_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->GetCheck();		

	iCheckedMP4_3_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->GetCheck();

	iCheckedAVI_3_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->GetCheck();
	
	iCheckedMP4_3_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->GetCheck();

	iCheckedAVI_4_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->GetCheck();		

	iCheckedMP4_4_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->GetCheck();

	iCheckedAVI_4_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->GetCheck();
	
	iCheckedMP4_4_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_1_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedAVI_2_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->SetCheck( TRUE ); }	

	if ( iCheckedAVI_2_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->SetCheck( TRUE ); }		
}

void CFileRecordDialog::OnAviRadio42() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname4_2_480_6M.avi"));

	m_edit_record_4_2.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1, iCheckedAVI_1_2, iCheckedMP4_1_2;
	
	UINT iCheckedAVI_2_1, iCheckedMP4_2_1, iCheckedAVI_2_2, iCheckedMP4_2_2;

	UINT iCheckedAVI_3_1, iCheckedMP4_3_1, iCheckedAVI_3_2, iCheckedMP4_3_2;
	
	UINT iCheckedAVI_4_1, iCheckedMP4_4_1, iCheckedAVI_4_2, iCheckedMP4_4_2;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->GetCheck();

	iCheckedAVI_1_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->GetCheck();

	iCheckedMP4_1_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->GetCheck();

	iCheckedAVI_2_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->GetCheck();

	iCheckedMP4_2_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->GetCheck();
	
	iCheckedAVI_2_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_2_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->GetCheck();

	iCheckedAVI_3_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->GetCheck();		

	iCheckedMP4_3_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->GetCheck();

	iCheckedAVI_3_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->GetCheck();
	
	iCheckedMP4_3_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->GetCheck();

	iCheckedAVI_4_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->GetCheck();		

	iCheckedMP4_4_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->GetCheck();

	iCheckedAVI_4_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->GetCheck();
	
	iCheckedMP4_4_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_1_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedAVI_2_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->SetCheck( TRUE ); }	

	if ( iCheckedAVI_2_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->SetCheck( TRUE ); }		
}

void CFileRecordDialog::OnMp4Radio422() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\unname4_2_480_6M.mp4"));

	m_edit_record_4_2.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1, iCheckedAVI_1_2, iCheckedMP4_1_2;
	
	UINT iCheckedAVI_2_1, iCheckedMP4_2_1, iCheckedAVI_2_2, iCheckedMP4_2_2;

	UINT iCheckedAVI_3_1, iCheckedMP4_3_1, iCheckedAVI_3_2, iCheckedMP4_3_2;
	
	UINT iCheckedAVI_4_1, iCheckedMP4_4_1, iCheckedAVI_4_2, iCheckedMP4_4_2;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->GetCheck();

	iCheckedAVI_1_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->GetCheck();

	iCheckedMP4_1_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->GetCheck();

	iCheckedAVI_2_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->GetCheck();

	iCheckedMP4_2_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->GetCheck();
	
	iCheckedAVI_2_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedMP4_2_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->GetCheck();

	iCheckedAVI_3_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->GetCheck();		

	iCheckedMP4_3_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->GetCheck();

	iCheckedAVI_3_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->GetCheck();
	
	iCheckedMP4_3_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->GetCheck();

	iCheckedAVI_4_1 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->GetCheck();		

	iCheckedMP4_4_1 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->GetCheck();

	iCheckedAVI_4_2 = ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->GetCheck();
	
	iCheckedMP4_4_2 = ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_1_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_1_2))->SetCheck( TRUE ); }

	if ( iCheckedAVI_2_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_1))->SetCheck( TRUE ); }	

	if ( iCheckedAVI_2_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_2_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_2_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_1_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_3_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedMP4_3_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_3_2_))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_1 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_1 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_1))->SetCheck( TRUE ); }

	if ( iCheckedAVI_4_2 ){ ((CButton*)GetDlgItem(IDC_AVI_RADIO_4_2))->SetCheck( TRUE ); }

	if ( iCheckedMP4_4_2 ){ ((CButton*)GetDlgItem(IDC_MP4_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnButtonRecordStop22() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_btnRecordStart_2_2.EnableWindow( TRUE );

	m_btnRecordStop_2_2.EnableWindow( FALSE ); 

	if ( m_pMainDialog->m_hVideoDevice[ 1 ] != 0 ) {

		QCAP_STOP_RECORD( m_pMainDialog->m_hVideoDevice[ 1 ], 1 );

		m_pMainDialog->m_bIsRecord2_2 = false;
	}	
}

void CFileRecordDialog::OnButtonRecordStart31() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();
	
	m_btnRecordStart_3_1.EnableWindow( FALSE ); 

	m_btnRecordStop_3_1.EnableWindow( TRUE ); 

	m_pMainDialog->m_bSupportGPU3_1 = m_checkGPU_3_1.GetCheck();

	if ( m_pMainDialog->m_hVideoDevice[ 2 ] != 0 ) {

		CString strFullPathName;

		UINT iCheckedAVI, iCheckedMP4;

		iCheckedAVI = IsDlgButtonChecked( IDC_AVI_RADIO_3_1_ );

		iCheckedMP4 = IsDlgButtonChecked( IDC_MP4_RADIO_3_1_ );

		if ( iCheckedAVI == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 2 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname3_1_1080_12M.avi");
		}

        if ( iCheckedMP4 == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 2 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname3_1_1080_12M.mp4");
		}

		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

		if ( m_pMainDialog->m_bSupportGPU3_1 ) {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 2 ], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

			QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 2 ], 0, psz );			
		}
		else {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 2 ], 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

			QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 2 ], 0, psz );		
		}

		m_pMainDialog->m_bIsRecord3_1 = true;

		strFullPathName.ReleaseBuffer();
	}
}

void CFileRecordDialog::OnButtonRecordStart32() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_btnRecordStart_3_2.EnableWindow( FALSE ); 

	m_btnRecordStop_3_2.EnableWindow( TRUE ); 

	m_pMainDialog->m_bSupportGPU3_2 = m_checkGPU_3_2.GetCheck();

	if ( m_pMainDialog->m_hVideoDevice[ 2 ] != 0 ) {

		CString strFullPathName;

		UINT iCheckedAVI, iCheckedMP4;

		iCheckedAVI = IsDlgButtonChecked( IDC_AVI_RADIO_3_2_ );

		iCheckedMP4 = IsDlgButtonChecked( IDC_MP4_RADIO_3_2_ );

		if ( iCheckedAVI == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 2 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname3_2_480_6M.avi");
		}

        if ( iCheckedMP4 == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 2 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname3_2_480_6M.mp4");
		}

		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

		if ( m_pMainDialog->m_bSupportGPU3_2 ) {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 2 ], 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );

			QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 2 ], 1, psz );			
		}
		else {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 2 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );

			QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 2 ], 1, psz );
		}

		m_pMainDialog->m_bIsRecord3_2 = true;

		strFullPathName.ReleaseBuffer();
	}	
}

void CFileRecordDialog::OnButtonRecordStop31() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_btnRecordStart_3_1.EnableWindow( TRUE ); 

	m_btnRecordStop_3_1.EnableWindow( FALSE ); 

	if ( m_pMainDialog->m_hVideoDevice[ 2 ] != 0 ) {

		QCAP_STOP_RECORD( m_pMainDialog->m_hVideoDevice[ 2 ], 0 );

		m_pMainDialog->m_bIsRecord3_1 = false;
	}	
}

void CFileRecordDialog::OnButtonRecordStop32() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_btnRecordStart_3_2.EnableWindow( TRUE );

	m_btnRecordStop_3_2.EnableWindow( FALSE ); 

	if ( m_pMainDialog->m_hVideoDevice[ 2 ] != 0 ) {

		QCAP_STOP_RECORD( m_pMainDialog->m_hVideoDevice[ 2 ], 1 );

		m_pMainDialog->m_bIsRecord3_2 = false;
	}	
}

void CFileRecordDialog::OnButtonRecordStart41() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_btnRecordStart_4_1.EnableWindow( FALSE ); 

	m_btnRecordStop_4_1.EnableWindow( TRUE ); 

	m_pMainDialog->m_bSupportGPU4_1 = m_checkGPU_4_1.GetCheck();

	if ( m_pMainDialog->m_hVideoDevice[ 3 ] != 0 ) {

		CString strFullPathName;

		UINT iCheckedAVI, iCheckedMP4;

		iCheckedAVI = IsDlgButtonChecked( IDC_AVI_RADIO_4_1 );

		iCheckedMP4 = IsDlgButtonChecked( IDC_MP4_RADIO_4_1 );

		if ( iCheckedAVI == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 3 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname4_1_1080_12M.avi");
		}

        if ( iCheckedMP4 == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 3 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname4_1_1080_12M.mp4");
		}

		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

		if ( m_pMainDialog->m_bSupportGPU4_1 ) {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 3 ], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

			QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 3 ], 0, psz );			
		}
		else {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 3 ], 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

			QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 3 ], 0, psz );		
		}

		m_pMainDialog->m_bIsRecord4_1 = true;

		strFullPathName.ReleaseBuffer();
	}		
}

void CFileRecordDialog::OnButtonRecordStop41() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_btnRecordStart_4_1.EnableWindow( TRUE ); 

	m_btnRecordStop_4_1.EnableWindow( FALSE ); 

	if ( m_pMainDialog->m_hVideoDevice[ 3 ] != 0 ) {

		QCAP_STOP_RECORD( m_pMainDialog->m_hVideoDevice[ 3 ], 0 );

		m_pMainDialog->m_bIsRecord4_1 = false;
	}	
}

void CFileRecordDialog::OnButtonRecordStart42() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_btnRecordStart_4_2.EnableWindow( FALSE ); 

	m_btnRecordStop_4_2.EnableWindow( TRUE ); 

	m_pMainDialog->m_bSupportGPU4_2 = m_checkGPU_4_2.GetCheck();

	if ( m_pMainDialog->m_hVideoDevice[ 3 ] != 0 ) {

		CString strFullPathName;

		UINT iCheckedAVI, iCheckedMP4;

		iCheckedAVI = IsDlgButtonChecked( IDC_AVI_RADIO_4_2 );

		iCheckedMP4 = IsDlgButtonChecked( IDC_MP4_RADIO_4_2 );

		if ( iCheckedAVI == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 3 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname4_2_480_6M.avi");
		}

        if ( iCheckedMP4 == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 3 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			strFullPathName = m_pMainDialog->m_strRecordPath + _T("\\unname4_2_480_6M.mp4");
		}

		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

		if ( m_pMainDialog->m_bSupportGPU4_2 ) {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 3 ], 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );

			QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 3 ], 1, psz );			
		}
		else {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 3 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );

			QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 3 ], 1, psz );
		}

		m_pMainDialog->m_bIsRecord4_2 = true;

		strFullPathName.ReleaseBuffer();
	}	
}

void CFileRecordDialog::OnButtonRecordStop42() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_btnRecordStart_4_2.EnableWindow( TRUE );

	m_btnRecordStop_4_2.EnableWindow( FALSE ); 

	if ( m_pMainDialog->m_hVideoDevice[ 3 ] != 0 ) {

		QCAP_STOP_RECORD( m_pMainDialog->m_hVideoDevice[ 3 ], 1 );

		m_pMainDialog->m_bIsRecord4_2 = false;
	}	

}
